import { jsx, jsxs } from "react/jsx-runtime";
import { track, useEditor, usePresence } from "@tldraw/editor";
import { useCallback } from "react";
import { useUiEvents } from "../../context/events.mjs";
import { useTranslation } from "../../hooks/useTranslation/useTranslation.mjs";
import { TldrawUiButton } from "../primitives/Button/TldrawUiButton.mjs";
import { TldrawUiButtonIcon } from "../primitives/Button/TldrawUiButtonIcon.mjs";
import { TldrawUiIcon } from "../primitives/TldrawUiIcon.mjs";
const PeopleMenuItem = track(function PeopleMenuItem2({ userId }) {
  const editor = useEditor();
  const msg = useTranslation();
  const trackEvent = useUiEvents();
  const presence = usePresence(userId);
  const handleFollowClick = useCallback(() => {
    if (editor.getInstanceState().followingUserId === userId) {
      editor.stopFollowingUser();
      trackEvent("stop-following", { source: "people-menu" });
    } else {
      editor.startFollowingUser(userId);
      trackEvent("start-following", { source: "people-menu" });
    }
  }, [editor, userId, trackEvent]);
  const theyAreFollowingYou = presence?.followingUserId === editor.user.getId();
  const youAreFollowingThem = editor.getInstanceState().followingUserId === userId;
  if (!presence) return null;
  return /* @__PURE__ */ jsxs("div", { className: "tlui-people-menu__item tlui-buttons__horizontal", children: [
    /* @__PURE__ */ jsxs(
      TldrawUiButton,
      {
        type: "menu",
        className: "tlui-people-menu__item__button",
        onClick: () => editor.zoomToUser(userId),
        onDoubleClick: handleFollowClick,
        children: [
          /* @__PURE__ */ jsx(TldrawUiIcon, { icon: "color", color: presence.color }),
          /* @__PURE__ */ jsx("div", { className: "tlui-people-menu__name", children: presence.userName ?? "New User" })
        ]
      }
    ),
    /* @__PURE__ */ jsx(
      TldrawUiButton,
      {
        type: "icon",
        className: "tlui-people-menu__item__follow",
        title: theyAreFollowingYou ? msg("people-menu.leading") : youAreFollowingThem ? msg("people-menu.following") : msg("people-menu.follow"),
        onClick: handleFollowClick,
        disabled: theyAreFollowingYou,
        "data-active": youAreFollowingThem || theyAreFollowingYou,
        children: /* @__PURE__ */ jsx(
          TldrawUiButtonIcon,
          {
            icon: theyAreFollowingYou ? "leading" : youAreFollowingThem ? "following" : "follow"
          }
        )
      }
    )
  ] });
});
export {
  PeopleMenuItem
};
//# sourceMappingURL=PeopleMenuItem.mjs.map
